/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.camera.capture.component.FileSaveComponent;
import io.github.mortuusars.exposure.gui.screen.ZoomableScreen;
import io.github.mortuusars.exposure.gui.screen.element.Pager;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import io.github.mortuusars.exposure.util.ItemAndStack;
import io.github.mortuusars.exposure.util.PagingDirection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhotographScreen
extends ZoomableScreen {
    public static final ResourceLocation WIDGETS_TEXTURE = Exposure.resource("textures/gui/widgets.png");
    private final List<ItemAndStack<PhotographItem>> photographs;
    private final List<String> savedExposures = new ArrayList<String>();
    private final Pager pager = new Pager(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK.get());

    public PhotographScreen(List<ItemAndStack<PhotographItem>> photographs) {
        super((Component)Component.m_237119_());
        Preconditions.checkState((!photographs.isEmpty() ? 1 : 0) != 0, (Object)"No photographs to display.");
        this.photographs = photographs;
        Minecraft.m_91087_().f_91068_.m_90926_(true);
        for (ItemAndStack<PhotographItem> photograph : photographs) {
            @Nullable Either<String, ResourceLocation> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
            if (idOrTexture == null) continue;
            idOrTexture.ifLeft(id -> ExposureClient.getExposureStorage().getOrQuery((String)id));
        }
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.zoomFactor = (float)this.f_96544_ / (float)ExposureClient.getExposureRenderer().getSize();
        ImageButton previousButton = new ImageButton(0, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 0, 0, 16, WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.PREVIOUS), (Component)Component.m_237115_((String)"gui.exposure.previous_page"));
        this.m_142416_((GuiEventListener)previousButton);
        ImageButton nextButton = new ImageButton(this.f_96543_ - 16, (int)((float)this.f_96544_ / 2.0f - 8.0f), 16, 16, 16, 0, 16, WIDGETS_TEXTURE, 256, 256, button -> this.pager.changePage(PagingDirection.NEXT), (Component)Component.m_237115_((String)"gui.exposure.next_page"));
        this.m_142416_((GuiEventListener)nextButton);
        this.pager.init(this.photographs.size(), true, (AbstractButton)previousButton, (AbstractButton)nextButton);
    }

    @Override
    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.pager.update();
        this.m_7333_(poseStack);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 500.0);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.x, (double)this.y, 0.0);
        poseStack.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)((float)this.f_96544_ / 2.0f), 0.0);
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        poseStack.m_85837_((double)((float)ExposureClient.getExposureRenderer().getSize() / -2.0f), (double)((float)ExposureClient.getExposureRenderer().getSize() / -2.0f), 0.0);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        ArrayList<ItemAndStack<PhotographItem>> photos = new ArrayList<ItemAndStack<PhotographItem>>(this.photographs);
        Collections.rotate(photos, -this.pager.getCurrentPage());
        PhotographRenderer.renderStackedPhotographs(photos, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, 255, 255, 255, 255);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPage());
        Either<String, ResourceLocation> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
        if (this.minecraft.f_91074_ != null && this.minecraft.f_91074_.m_7500_() && idOrTexture != null) {
            this.f_96547_.m_92883_(poseStack, "?", (float)(this.f_96543_ - this.f_96547_.m_92895_("?") - 10), 10.0f, -1);
            if (mouseX > this.f_96543_ - 20 && mouseX < this.f_96543_ && mouseY < 20) {
                ArrayList<Object> lines = new ArrayList<Object>();
                lines.add(Component.m_237110_((String)"gui.exposure.photograph_screen.drop_as_item_tooltip", (Object[])new Object[]{Component.m_237113_((String)"CTRL + I")}));
                lines.add((Component)idOrTexture.map(id -> Component.m_237110_((String)"gui.exposure.photograph_screen.copy_id_tooltip", (Object[])new Object[]{"CTRL + C"}), texture -> Component.m_237110_((String)"gui.exposure.photograph_screen.copy_texture_path_tooltip", (Object[])new Object[]{"CTRL + C"})));
                this.m_169388_(poseStack, lines, Optional.empty(), mouseX, mouseY + 20);
            }
        }
        if (((Boolean)Config.Client.SAVE_EXPOSURE_TO_FILE_WHEN_VIEWED.get()).booleanValue()) {
            this.trySaveToFile(photograph);
        }
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.pager.handleKeyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Screen.m_96637_() && player != null && player.m_7500_()) {
            ItemAndStack<PhotographItem> photograph = this.photographs.get(this.pager.getCurrentPage());
            if (keyCode == 67) {
                @Nullable Either<String, ResourceLocation> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
                if (idOrTexture != null) {
                    String text = (String)idOrTexture.map(id -> id, ResourceLocation::toString);
                    Minecraft.m_91087_().f_91068_.m_90911_(text);
                    player.m_5661_((Component)Component.m_237110_((String)"gui.exposure.photograph_screen.copied_message", (Object[])new Object[]{text}), false);
                }
                return true;
            }
            if (keyCode == 73) {
                if (Minecraft.m_91087_().f_91072_ != null) {
                    Minecraft.m_91087_().f_91072_.m_105239_(photograph.getStack().m_41777_());
                    player.m_5661_((Component)Component.m_237110_((String)"gui.exposure.photograph_screen.item_dropped_message", (Object[])new Object[]{photograph.getStack().toString()}), false);
                }
                return true;
            }
        }
        return this.pager.handleKeyReleased(keyCode, scanCode, modifiers) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    private void trySaveToFile(ItemAndStack<PhotographItem> photograph) {
        if (Minecraft.m_91087_().f_91074_ == null || photograph.getStack().m_41783_() == null) {
            return;
        }
        CompoundTag tag = photograph.getStack().m_41783_();
        if (tag == null || Minecraft.m_91087_().f_91074_ == null || !tag.m_128425_("PhotographerId", 11) || !tag.m_128342_("PhotographerId").equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
            return;
        }
        @Nullable Either<String, ResourceLocation> idOrTexture = photograph.getItem().getIdOrTexture(photograph.getStack());
        if (idOrTexture == null) {
            return;
        }
        idOrTexture.ifLeft(id -> {
            if (this.savedExposures.contains(id)) {
                return;
            }
            ExposureClient.getExposureStorage().getOrQuery((String)id).ifPresent(exposure -> {
                this.savedExposures.add((String)id);
                new Thread(() -> FileSaveComponent.withDefaultFolders(id).save(exposure.getPixels(), exposure.getWidth(), exposure.getHeight(), exposure.getProperties()), "ExposureSaving").start();
            });
        });
    }
}

